<?php

namespace Elementor;

class goto_search_tour extends Widget_Base {

    public function get_name() {
        return 'search-tour';
    }

    public function get_categories() {
        return array( 'goto-theme' );
    }

    public function get_title() {
        return esc_html__( 'Search Tour', 'goto' );
    }

    public function get_icon() {
        return 'eicon-search';
    }

    protected function register_controls() {
        $this->start_controls_section( 'ps_general', array(
            'label' => esc_html__( 'General', 'goto' ),
        ));

        /*BORDER RADIUS*/
        $this->add_control( 'radius', array(
            'type'    => Controls_Manager::SLIDER,
            'label'   => esc_html__( 'Border radius', 'goto' ),
            'default' => array(
                'size' => 5,
            ),
            'range' => array(
                'px' => array(
                    'min'  => 0,
                    'max'  => 100,
                    'step' => 1,
                )
            ),
            'size_units' => array( 'px' ),
            'selectors'  => array(
                '{{WRAPPER}} .place-search-spn input'  => 'border-radius: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .place-search-spn button' => 'border-radius: {{SIZE}}{{UNIT}};',
            ),
        ));

        /*INPUT BACKGROUND COLOR*/
        $this->add_control( 'input_bg', array(
            'type'      => Controls_Manager::COLOR,
            'label'     => esc_html__( 'Input background', 'goto' ),
            'default'   => '#0c3555',
            'selectors' => array(
                '{{WRAPPER}} .place-search-spn input' => 'background-color: {{VALUE}};',
            ),
        ));

        /*TEXT COLOR*/
        $this->add_control( 'input_color', array(
            'type'      => Controls_Manager::COLOR,
            'label'     => esc_html__( 'Input, border color', 'goto' ),
            'default'   => 'rgba(255,255,255,0.3)',
            'selectors' => array(
                '{{WRAPPER}} .place-search-spn input'       => 'color: {{VALUE}};',
                '{{WRAPPER}} .place-search-spn input:focus' => 'border-color: {{VALUE}};',
            ),
        ));

        /*FOCUS COLOR*/
        $this->add_control( 'input_focus', array(
            'type'      => Controls_Manager::COLOR,
            'label'     => esc_html__( 'Text, icon color', 'goto' ),
            'default'   => '#fff',
            'selectors' => array(
                '{{WRAPPER}} .place-search-spn h5'      => 'color: {{VALUE}};',
                '{{WRAPPER}} .place-search-spn label'       => 'color: {{VALUE}};',
                '{{WRAPPER}} .place-search-spn input:focus' => 'color: {{VALUE}};',
                '{{WRAPPER}} .place-search-spn button'      => 'color: {{VALUE}};',
            ),
        ));

        /*SUBMIT BACKGROUND*/
        $this->add_control( 'submit_bg', array(
            'type'      => Controls_Manager::COLOR,
            'label'     => esc_html__( 'Submit button background', 'goto' ),
            'default'   => '#ec5849',
            'selectors' => array(
                '{{WRAPPER}} .place-search-spn button' => 'background-color: {{VALUE}};',
            ),
        ));

        $this->end_controls_section();
    }

    public function _content_template() {
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        goto_date_picker( '#place-search-time' );
        ?>
            <form action="<?php echo esc_url( goto_template_name() ); ?>" id="place-search-wd" target="_blank">
                <div class="place-search-spn">
                    <h5><?php esc_html_e( 'Keywords', 'goto' ); ?></h5>
                    <label for="i-dest" class="goto-icon-location">
                        <input id="i-dest" type="text" placeholder="<?php esc_attr_e( 'Enter a destination or tour name', 'goto' ); ?>" name="keywords">
                    </label>
                </div>
                <div class="place-search-spn">
                    <h5><?php esc_html_e( 'When', 'goto' ); ?></h5>
                    <label for="place-search-time" class="goto-icon-calendar-3">
                        <input id="place-search-time" type="text" placeholder="<?php esc_attr_e( 'Anytime', 'goto' ); ?>" name="start_date">
                    </label>
                </div>
                <div class="place-search-spn">
                    <h5><?php esc_html_e( 'Guests', 'goto' ); ?></h5>
                    <label for="i-guest" class="goto-icon-user">
                        <input id="i-guest" type="number" placeholder="<?php esc_attr_e( '01 guest', 'goto' ); ?>" name="avaibility">
                    </label>
                </div>
                <div class="place-search-spn">
                    <button type="submit"><?php esc_html_e( 'Search', 'goto' ); ?></button>
                </div>
            </form>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new goto_search_tour() );